<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="styles.css"> <!-- Reference to CSS file -->
    <title>Video Host Buttons</title>
</head>

<style>/* styles.css */
body {
    font-family: Arial, sans-serif;
    display: flex;
    justify-content: center;
    align-items: center;
    height: 100vh;
    background-color: #f0f0f0; /* Light background */
    margin: 0; /* Remove default body margin */
}

.video-host-buttons {
    display: flex;
    flex-wrap: wrap; /* Allow buttons to wrap to the next line on smaller screens */
    justify-content: center; /* Center the buttons */
    gap: 1rem; /* Spacing between buttons */
    padding: 1rem; /* Add some padding around the button container */
}

.button {
    padding: 10px 20px;
    text-decoration: none;
    color: white;
    border-radius: 5px;
    transition: background-color 0.3s;
    flex: 1 1 150px; /* Allow buttons to grow/shrink with a minimum width */
    text-align: center; /* Center text in buttons */
}

.youtube {
    background-color: #FF0000; /* YouTube Red */
}

.vimeo {
    background-color: #1AB7E2; /* Vimeo Blue */
}

.dailymotion {
    background-color: #A500C7; /* Dailymotion Purple */
}

.twitch {
    background-color: #6441A5; /* Twitch Purple */
}

.flickr {
    background-color: #FF0084; /* Flickr Pink */
}

.button:hover {
    opacity: 0.9; /* Hover effect */
}

/* Responsive adjustments */
@media (max-width: 600px) {
    .video-host-buttons {
        flex-direction: column; /* Stack buttons vertically on small screens */
        align-items: stretch; /* Align buttons to fill the width */
    }
}
</style>


<body>

<div class="video-host-buttons">
    <a href="https://www.youtube.com/" class="button youtube">YouTube</a>
    <a href="https://vimeo.com/" class="button vimeo">Vimeo</a>
    <a href="https://www.dailymotion.com/" class="button dailymotion">Dailymotion</a>
    <a href="https://www.twitch.tv/" class="button twitch">Twitch</a>
    <a href="https://www.flickr.com/videos/" class="button flickr">Flickr Videos</a>
</div>

</body>
</html>
